/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * NewJFrame.java
 *
 * Created on 12-mar-2010, 15.09.48
 */

package client_server;

import gdr.maps.MapPaths;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Vector;

import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;



/**
 *
 * @author iamdelac
 */
public class MainForm extends javax.swing.JFrame{

   
    private ImageIcon background;
    private JScrollPane scrollPane;
    private MapPaths mapPaths;
    private String ostacoli;
    private Player mainPlayer;
    private JPanel panel;
    private Vector<RemotePlayer> remotePlayerList;
    private Vector<Thread> remoteThreads;



    /** Creates new form NewJFrame */
    public MainForm(Player mainPlayer) {
      //  initComponents();
    	 this.mainPlayer = mainPlayer;
         this.remotePlayerList = new Vector<RemotePlayer>();
         this.remoteThreads = new Vector<Thread>();
         initCustomComponents();

    }

    

   
 



    public  MapPaths getMap(){
        return mapPaths;
    }

    public Player getMainPlayer(){
        return mainPlayer;
    }
    
   

    private void initCustomComponents(){
        ostacoli = Client.instance.leggiOstacoli();
        mapPaths = new MapPaths(ostacoli);
        background = new ImageIcon(getClass().getResource("/gdr/maps/bk.jpg"));
        panel = new JPanel()
            {@Override
             protected void paintComponent(Graphics g)
                {g.drawImage(background.getImage(), 0, 0, null); //full size image
                // Dimension d = getSize();  //scale at panel size
                // g.drawImage(background.getImage(), 0, 0, d.width, d.height, null);
                }
            };
            panel.setDoubleBuffered(true);
            panel.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mousePressed(java.awt.event.MouseEvent evt) {
                System.out.println("      rombo start= "+getRombo(mainPlayer.getLocation().x, mainPlayer.getLocation().y));
                System.out.println("      rombo fine= "+getRombo(evt.getX(), evt.getY()));
                mainPlayer.muovi(new Point(evt.getX(), evt.getY()), 0);
                
            }
                 });
            this.addWindowListener(new WindowAdapter() {
            	public void windowClosing(WindowEvent e) {
            	 Client.instance.disconnetti();
            	}
            	});
        panel.setLayout(null);
        panel.setOpaque(false);
        Dimension dim = new Dimension( background.getIconWidth()+getInsets().left+getInsets().right, background.getIconHeight()+getInsets().top+getInsets().bottom) ;
        panel.setPreferredSize(dim);
	setResizable(true);
        scrollPane = new JScrollPane(panel);
        scrollPane.getHorizontalScrollBar().setEnabled(false);
        scrollPane.getVerticalScrollBar().setEnabled(false);
        scrollPane.getVerticalScrollBar().setValue(170);
        scrollPane.getHorizontalScrollBar().setValue(200);
        getContentPane().add(scrollPane);
        mainPlayer.setLocation(400, 200);
        panel.add(mainPlayer);
        
       





        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);

        setSize(500,300);

        //pack();  // sized to fit the preferred size and layouts of its subcomponents


        Thread t1 = new Thread(mainPlayer);
        t1.setName("player1");
        t1.start();
    }


    

public void addPlayer(RemotePlayer rp){
	System.out.println("sono "+mainPlayer.nome_player+" e ho aggiunto "+rp.nome_player);
	rp.setLocation(400, 200);
	remotePlayerList.add(rp);
    panel.add(rp);	
    Thread t2 = new Thread(rp);
    remoteThreads.add(t2);
    t2.setName(rp.nome_player);
    t2.start();
}

public void removePlayer(int i){
	System.out.println("sono "+mainPlayer.nome_player+" e ho rimosso "+remotePlayerList.get(i).nome_player);
	panel.remove(remotePlayerList.remove(i));
	remoteThreads.remove(i).destroy();
}

public void updateRemotePlayers( Vector<String[]> infos){
	  try{
		 RemotePlayer temp;	
		 int j=0;
		 while( j<(infos.size()-(remotePlayerList.size()+1)))
			 	{
				 temp = new RemotePlayer(infos.get(j+remotePlayerList.size()+1)[0]);
				 addPlayer(temp);	
				 j++;
			 	}
		j=0;
		while (j<(((remotePlayerList.size()+1))-infos.size()))
			 	{
				 removePlayer((remotePlayerList.size()+1)-j);
				 j++;
			 	}	
		 j=0;
		 int i=0;
		 while( i<infos.size())
		  {
			if( ! infos.get(i)[0].equals(this.mainPlayer.nome_player))
			  {
			   temp = remotePlayerList.get(j);
			   temp.nome_player = infos.get(i)[0];			   
			   temp.stato = infos.get(i)[1]; 
			   temp.orientation = infos.get(i)[2];
			   temp.setLocation(Integer.parseInt(infos.get(i)[3]), Integer.parseInt(infos.get(i)[4]));
			   j++;
			  }
			else if ( !infos.get(i)[5].equals(""))
				{
				 this.mainPlayer.riceviColpo(new Point(Integer.parseInt(infos.get(i)[5]),Integer.parseInt(infos.get(i)[6])));
				}
			i++;
		 }	
		}catch(Exception ex){System.out.println("synch problems");ex.printStackTrace();}
	}






public int getRombo(int x, int y)
  {
  int n_rombo=-1;
  int altezza = Constants.ALTEZZArOMBO;
  int larghezza = Constants.LARGHEZZArOMBO;
  int quadrato = ((x/larghezza)*Constants.righe/2)+(y/altezza);
  // cerco quale sotto-quadrato
  if (x > larghezza*(x/larghezza) +larghezza/2)
      {//meta' a destra
        if(y < altezza*(y/altezza) +altezza/2)
            { //meta' sopra
               double y_latoM = (altezza*(y/altezza))+altezza/2;
               double x_diagonale = x - ((larghezza*(x/larghezza))+larghezza/2);
               double pezzetto_diagonale = ((Math.sqrt((altezza/2*altezza/2)+(larghezza/2*larghezza/2)))/(larghezza/2))*x_diagonale;
               double puntoDiagonale = (y_latoM)     -   (Math.sqrt(-(x_diagonale*x_diagonale)+(pezzetto_diagonale*pezzetto_diagonale)) /** (x_diagonale)*/);
               if (y < puntoDiagonale)
                   { // sopra diagonale
                    n_rombo = (quadrato*2)-1;
                   }
               else{ // sotto diagonale
                    n_rombo = (quadrato*2)+Constants.righe;
                   }
            }
        else
            { //meta' sotto
             double y_latoM = (altezza*(y/altezza))+altezza/2;
               double x_diagonale = x - ((larghezza*(x/larghezza))+larghezza/2);
               double pezzetto_diagonale = ((Math.sqrt((altezza/2*altezza/2)+(larghezza/2*larghezza/2)))/(larghezza/2))*x_diagonale;
               double puntoDiagonale = (y_latoM)     +   (Math.sqrt(-(x_diagonale*x_diagonale)+(pezzetto_diagonale*pezzetto_diagonale)) /** (x_diagonale)*/);
             if (y < puntoDiagonale)
                   { // sopra diagonale
                    n_rombo = (quadrato*2)+Constants.righe;
                   }
               else{ // sotto diagonale
                    n_rombo = (quadrato*2)+1;
                   }
            }
      }
  else
      {//meta' a sinistra
       if(y < altezza*(y/altezza) +altezza/2)
            { //meta' sopra
               double y_latoM = (altezza*(y/altezza))+altezza/2;
               double x_diagonale = x - ((larghezza*(x/larghezza)))-(larghezza/2);
               double pezzetto_diagonale = ((Math.sqrt((altezza/2*altezza/2)+(larghezza/2*larghezza/2)))/(larghezza/2))*x_diagonale;
               double puntoDiagonale = (y_latoM)     -   (Math.sqrt(-(x_diagonale*x_diagonale)+(pezzetto_diagonale*pezzetto_diagonale)) /** (x_diagonale)*/);
               if (y < puntoDiagonale)
                   { // sopra diagonale
                    n_rombo = quadrato*2-1;
                   }
               else{ // sotto diagonale
                    n_rombo = quadrato*2;
                   }
            }
        else
            { //meta' sotto
           double y_latoM = (altezza*(y/altezza))+altezza/2;
               double x_diagonale = x - ((larghezza*(x/larghezza)))-(larghezza/2);
               double pezzetto_diagonale = ((Math.sqrt((altezza/2*altezza/2)+(larghezza/2*larghezza/2)))/(larghezza/2))*x_diagonale;
               double puntoDiagonale = (y_latoM)     +   (Math.sqrt(-(x_diagonale*x_diagonale)+(pezzetto_diagonale*pezzetto_diagonale)) /** (x_diagonale)*/);
             if (y < puntoDiagonale)
                   { // sopra diagonale
                    n_rombo = quadrato*2;
                   }
               else{ // sotto diagonale
                    n_rombo = quadrato*2+1;
                   }
            }
      }
   return n_rombo;
  }
   
   
}
